import sage.tables.elliptic_curves as ec
from sage.ellcurve.ellcurve import *


def check(N1,N2):
    F = open("surj.%s-%s"%(N1,N2),"w")
    db = ec.Database()
    for N in xrange(N1,N2+1):
        for E in db.optimal_curves(N):
            E2 = EllipticCurve(E)
            v = E2.non_surjective()
            s = "%6s %4s %1s %1s %15s %30s"%(E.conductor, E.iso_class,
                                             E.number, E.rank,
                                             str(v).replace(" ",""),
                                             str(E.a_invariants).replace(" ",""))
            print s
            F.write(s+"\n")
            F.flush()

def pad(s, n):
    if len(s) >= n:
        return s
    return s + " "*(n-len(s))
    
def beautify(file_in, file_out):
    out = open(file_out,"w")
    for line in open(file_in).xreadlines():
        N,iso,num,r,v,ainvs = line.split()
        #if int(N)>1000: return
        ainvs = ainvs.replace("L","")
        if v == "[0]":
            v = "[(0,'cm')]"  # changed notation for CM midway through computation
        t = "%s %s %s %s %s %s"%(pad(N,7),pad(iso,7),pad(num,7),pad(r,7),pad(ainvs,40), v)
        out.write(t + "\n")
        #print t



def check_for_missing():
    surj = open("surj.1-30000").xreadlines()       # our table
    curves = open("curves.1-30000").xreadlines()   # cremona's table
    for line in surj:
        line2 = curves.next()
        m0,m1,m2,_,m3,_ = line.split()
        n0,n1,n2,n3,_,_,_ = line2.split()
        if m0 == '990': continue
        if m3 != n3:
            print line
            print line2
            return


def sort(file_in, file_out):
    """
    file_in is a formated file with lines like
    
       245     A       1       1       [0,0,1,-7,12]                            [(3,None)]
       
    file_out is created and the sorted version of file_in is written to it.
    """
    class E:
        def __init__(self, data):
            self.__data = data
        def __cmp__(self, other):
            if self.__data == other.__data:
                return 0
            if int(self.__data[0]) < int(other.__data[0]):
                return -1
            elif int(self.__data[0]) > int(other.__data[0]):
                return 1
            else:
                if len(self.__data[1]) < len(other.__data[1]):
                    return -1
                elif len(self.__data[1]) > len(other.__data[1]):
                    return 1
                else:
                    if self.__data[1][0] < other.__data[1][0]:
                        return -1
                    elif self.__data[1][0] > other.__data[1][0]:
                        return 1
                    return 0
        def __repr__(self):
            d = self.__data
            return "%s %s %s %s %s %s"%(pad(d[0],7),pad(d[1],7),pad(d[2],7),pad(d[3],7),pad(d[4],40), d[5])
        
    X = []
    for line in open(file_in).xreadlines():
        N,iso,num,r,v,ainvs = line.split()
        X.append(E((N,iso,num,r,v,ainvs)))
    X.sort()
    out = open(file_out,"w")
    for curve in X:
        out.write("%s\n"%curve)
    
