import sage.tables.elliptic_curves as ec
from sage.all import *


def lratio(N1,N2):
    F = open("lratio.%s-%s"%(N1,N2),"w")
    db = ec.Database()
    for N in xrange(N1,N2+1):
        for E in db.optimal_curves(N):
            E2 = EllipticCurve(E)
            try:
                L = E2.L_ratio()
                s = "%6s %4s %1s %1s %15s %30s"%(E.conductor, E.iso_class,
                                                 E.number, E.rank,
                                                 str(L),
                                                 str(E2.a_invariants()).replace(" ",""))
            except:
                s = "ERROR COMPUTING L-RATIO for %s"%E2
            print s
            F.write(s+"\n")
            F.flush()


def kato_bad_squaredivisors(file="lratio.1-40000", outfile="kato_bad_squaredivisors.1-40000"):
    """
    List all curves of rank 0 such that the numerator of L-ratio
    L(1)/Omega is divisible by p^2, where p>= is a prime that does not
    #E(Q)_tor and p does not divide #Sha_an(E).
    """
    out = open(outfile,"w")
    for line in open("lratio.1-40000").xreadlines():
        N, iso, num, r, Lratio, ainvs = line.split()
        N = int(N); r = int(r)
        assert num == "1"
        if r == 0:
            Lratio = QQ(Lratio)
            E = EllipticCurve("%s%s%s"%(N,iso,num))
            T = E.torsion_order()
            sha_an = E.sha_an(use_database=True)
            P = [p for p, e in Lratio.numerator().factor() if p >= 5 and (N*T) % p != 0 and (e - valuation(sha_an,p)) >= 2]
            if len(P) > 0:
                R = [p for p in P if E.is_surjective(p)]   # throw away non-surjective primes.
                Q = [p for p in P if not E.is_surjective(p)]    # record questionable
                s = "%s\t%s\t%s"%(line[:-1],str(R).replace(" ",""), str(Q).replace(" ",""))
                print s
                out.write(s + "\n")
                out.flush()
