print "__SAGE_BEGIN__139"
os.chdir("/Volumes/WINDOWS XP/Documents and Settings/William Stein/Desktop/share/riemann_notebook/worksheets/factoring_worksheet/cells/1")
import random

def factor_tree(n):
    rows = []
    ftree(rows, [n], Integer(0), factor(n))
    return draw_ftree(rows)

def ftree(rows, v, i, F):
    if len(v) > Integer(0):
        # add a row to g at the ith level.
        rows.append(v)
    w = []
    for k in v:
        if k is None or is_prime(k):
            w.append(None)
        else:
            d = random.choice(divisors(k)[1:-1])
            w.append(d)
            e = k//d
            if e == Integer(1):
                w.append(None)
            else:
                w.append(e)
    if len(w) > len(v):
        ftree(rows, w, i+Integer(1), F)


def draw_ftree(rows):
    g = Graphics()
    for i in range(len(rows)):
        cur = rows[i]
        for j in range(len(cur)):
            if not cur[j] is None:
                if is_prime(cur[j]):
                     c = (Integer(1),Integer(0),Integer(0))
                else:
                     c = (Integer(0),Integer(0),RealNumber('.4'))
                g += text(str(cur[j]), (j*Integer(2)-len(cur),-i), fontsize=Integer(7), rgbcolor=c)
    return g
print "__SAGE_VARS__=%s"%_support_.variables(True)
print "__SAGE_END__139"
