print "__SAGE_BEGIN__171"
os.chdir("/Volumes/WINDOWS XP/Documents and Settings/William Stein/Desktop/share/riemann_notebook/worksheets/factoring_worksheet/cells/1")
import random

def factor_tree(n):
    rows = []
    v = [(n,None,Integer(0))]
    ftree(rows, v, Integer(0), factor(n))
    return draw_ftree(rows)

def ftree(rows, v, i, F):
    if len(v) > Integer(0):
        # add a row to g at the ith level.
        rows.append(v)
    w = []
    for i in range(len(v)):
        k, _,_ = v[i]
        if k is None or is_prime(k):
            w.append((None,None,None))
        else:
            d = random.choice(divisors(k)[1:-1])
            w.append((d,k,i))
            e = k//d
            if e == Integer(1):
                w.append((None,None))
            else:
                w.append((e,k,i))
    if len(w) > len(v):
        ftree(rows, w, i+Integer(1), F)


def draw_ftree(rows):
    g = Graphics()
    for i in range(len(rows)):
        cur = rows[i]
        for j in range(len(cur)):
            e, f, k = cur[j]
            if not e is None:
                if is_prime(e):
                     c = (Integer(1),Integer(0),Integer(0))
                else:
                     c = (Integer(0),Integer(0),RealNumber('.4'))
                g += text(str(e), (j*Integer(2)-len(cur),-i), fontsize=Integer(7), rgbcolor=c)
                if not k is None and not f is None:
                    g += line([(j*Integer(2)-len(cur),-i), (k*Integer(2)-len(rows[i-1]),-i+1)], alpha=RealNumber('0.4'), thickness=RealNumber('0.4'))
    return g
print "__SAGE_VARS__=%s"%_support_.variables(True)
print "__SAGE_END__171"
